@ECHO OFF
:: Copyright 2012 The Android Open Source Project
::
:: Licensed under the Apache License, Version 2.0 (the "License");
:: you may not use this file except in compliance with the License.
:: You may obtain a copy of the License at
::
::      http://www.apache.org/licenses/LICENSE-2.0
::
:: Unless required by applicable law or agreed to in writing, software
:: distributed under the License is distributed on an "AS IS" BASIS,
:: WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
:: See the License for the specific language governing permissions and
:: limitations under the License.

PATH=%PATH%;"%SYSTEMROOT%\System32"

:: Detect Fastboot version with inline PowerShell
:: Should work with Windows 7 and later

where /q fastboot || ECHO fastboot not found; please download the latest version at https://developer.android.com/studio/releases/platform-tools.html and add it to the shell PATH && EXIT /B

@PowerShell ^
$version=fastboot --version; ^
try { ^
    $verNum = $version[0].substring(17, 6); ^
    $verNum = $verNum.replace('.', ''); ^
    if ((-Not ($verNum -gt 2802)) -Or (-Not ($verNum -match '^[\d.]+$'))) { ^
        Exit 1 ^
    } ^
} catch { ^
    Exit 1 ^
}

IF %ERRORLEVEL% NEQ 0 (
  ECHO fastboot too old; please download the latest version at https://developer.android.com/studio/releases/platform-tools.html
  EXIT /B
)

fastboot flash bootloader bootloader-crosshatch-b1c1-0.3-7241706.img
fastboot reboot-bootloader
ping -n 5 127.0.0.1 >nul
fastboot flash radio radio-crosshatch-g845-00173-210331-b-7249945.img
fastboot reboot-bootloader
ping -n 5 127.0.0.1 >nul
fastboot erase avb_custom_key
fastboot flash avb_custom_key avb_pkmd.bin
fastboot reboot-bootloader
ping -n 5 127.0.0.1 >nul
fastboot -w --skip-reboot update image-crosshatch-2021.06.20.20.zip
fastboot reboot-bootloader
ping -n 5 127.0.0.1 >nul

echo Press any key to exit...
pause >nul
exit
